//
//  $Id: WXKMailValueTransformer.m 108 2009-06-24 14:54:10Z fujidana $
//  Copyright 2008 FUJIDANA. All rights reserved.
//

#import "WXKMailValueTransformer.h"
#import "WXKEMail.h"
#import "WXKLightMail.h"

typedef enum _MailType
{
	EMailType,
	LightMailType
} MailType;


@interface WXKMailValueTransformer ()

+ (NSImage *)imageWithMailType:(MailType)type status:(int)status isLocked:(BOOL)locked;

@end

@implementation WXKMailValueTransformer

+ (Class)transformedValueClass
{
	return [NSImage class];
}

+ (BOOL)allowsReverseTransformation
{
	return NO;
}

- (id)transformedValue:(id)value
{
	if (value && [value isKindOfClass:[NSManagedObject class]])
	{
		MailType type = ([value isKindOfClass:[WXKLightMail class]]) ? LightMailType : EMailType;
		BOOL sealed = [[value valueForKey:@"status"] longValue];
		BOOL locked = [[value valueForKey:@"secured"] boolValue];
		
		return [[self class] imageWithMailType:type status:sealed isLocked:locked];
	}
	return nil;
}

+ (NSImage *)imageWithMailType:(MailType)type status:(int)status isLocked:(BOOL)locked
{
	NSString *str = (type == EMailType ? @"E": @"L");
	NSString *imageName = [NSString stringWithFormat:@"MailIcon_%@_%d_%d", 
			str,
			status,
			locked];
	
	NSImage *image = [NSImage imageNamed:imageName];
	if (image == nil)
	{
		NSDictionary *attributes = [NSDictionary dictionaryWithObject:[NSFont systemFontOfSize:-1.0] forKey:NSFontAttributeName];
		
		// first, calculate the image width
		float imageWidth = 0;
		
		// email or light mail
		imageWidth += [str sizeWithAttributes:attributes].width;
		
		imageWidth += 2.0;
		
		// status (sealed mail)
		if (status == WXKMailSealedStatus) imageWidth += [[NSImage imageNamed:@"TableColumnMailSealedicon.tiff"] size].width;
		else if (status == WXKMailUnsealedStatus) imageWidth += [[NSImage imageNamed:@"TableColumnMailUnsealedicon.tiff"] size].width;
		else imageWidth += [[NSString stringWithFormat:@"%d", status] sizeWithAttributes:attributes].width;
		
		// lock
		if (locked)
		{
			imageWidth += 2.0;
			imageWidth += [[NSImage imageNamed:@"TableColumnLockIcon.tiff"] size].width;
		}
		
		// second, draw into graphics context of image object.
		image = [[[NSImage alloc] initWithSize:NSMakeSize(imageWidth, 16.0)] autorelease];
		[image lockFocus];
		NSPoint curPoint = NSZeroPoint;
		
		// draws characters
		[str drawAtPoint:NSZeroPoint withAttributes:attributes];
//		[str drawWithRect:tmpRect options:0 attributes:attributes];
		curPoint.x += [str sizeWithAttributes:attributes].width;
		curPoint.x += 2.0;
		
		// draws a mail image
		if (status == WXKMailSealedStatus)
		{
			NSPoint tmpPoint = curPoint;
			tmpPoint.y += 2.0;
			NSImage *statusImage = [NSImage imageNamed:@"TableColumnMailSealedicon.tiff"];
			[statusImage drawAtPoint:tmpPoint fromRect:NSZeroRect operation:NSCompositeCopy fraction:1.0];
			curPoint.x += [statusImage size].width;
		}
		else if (status == WXKMailUnsealedStatus)
		{
			NSPoint tmpPoint = curPoint;
			tmpPoint.y += 2.0;
			NSImage *statusImage = [NSImage imageNamed:@"TableColumnMailUnsealedicon.tiff"];
			[statusImage drawAtPoint:tmpPoint fromRect:NSZeroRect operation:NSCompositeCopy fraction:1.0];
			curPoint.x += [statusImage size].width;
		}
		else
		{
			NSString *str = [NSString stringWithFormat:@"%d", status];
			[str drawAtPoint:curPoint withAttributes:attributes];
			curPoint.x += [str sizeWithAttributes:attributes].width;
		}
		
		// draws a lock image if necessary
		if (locked)
		{
			curPoint.x += 2.0;
			
			NSPoint tmpPoint = curPoint;
			tmpPoint.y += 2.0;
			NSImage *lockImage = [NSImage imageNamed:@"TableColumnLockIcon.tiff"];
			[lockImage drawAtPoint:tmpPoint fromRect:NSZeroRect operation:NSCompositeCopy fraction:1.0];
			curPoint.x += [lockImage size].width;
		}
		[image unlockFocus];
		
		// finally, store the image drawn above with a name.
		[image setName:imageName];
	}
	
	return image;
}

@end
